//=============================================================================
// MSCameraWindow.
//=============================================================================
class MSCameraWindow expands MenuUIWindow;

var MenuUIActionButtonWindow okButton;
var MenuUIActionButtonWindow exitButton;
var MenuUIEditWindow SelTagWindow;
var MenuUIEditWindow SelTitleWindow;
var MenuUIHeaderWindow winText;
var localized string okButtonText;
var localized string exitButtonText;
var MSUtilityGun _windowOwner;
var string SelRange;
var string SelTag;

event InitWindow()
{
   local Window W;

   Super.InitWindow();

   winClient.SetBackground(Texture'DeusExUI.MaskTexture');
   winClient.SetBackgroundStyle(DSTY_Modulated);

   W = winClient.NewChild(Class'Window');
   W.SetSize(ClientWidth, ClientHeight);
   W.SetBackground(Texture'DeusExUI.MaskTexture');
   W.SetBackgroundStyle(DSTY_Modulated);
   W.Lower();

   SelTagWindow = CreateMenuEditWindow(60, 45, 70, 30, winClient);
   SelTitleWindow = CreateMenuEditWindow(130, 45, 70, 30, winClient);

   okButton = winButtonBar.AddButton(okButtonText, HALIGN_Right);
   exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);

  if (Player.Weapon.IsA('MSUtilityGun'))
   {
     _WindowOwner = MSUtilityGun(Player.Weapon);
   }

  /*if ((_WindowOwner != None) && (_WindowOwner.Selected.IsA('SecurityCamera')))
  {
   SelTag = SecurityCamera(_WindowOwner.Selected).Tag;
   SelRange = SecurityCamera(_WindowOwner.Selected).cameraRange;
  }

   SelTagWindow.setText(""$SelTag$"");
   SelTitleWindow.setText(""$SelRange$"");*/
   SetTitle("Tag,Range");
}

function SetGoodies(SecurityCamera Selected)
{
   SelTag = Selected.GetPropertyText("Tag");
   SelRange = Selected.GetPropertyText("cameraRange");

   SelTagWindow.setText(""$SelTag$"");
   SelTitleWindow.setText(""$SelRange$"");
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch( buttonPressed )
	{
		case okButton:
			_windowOwner.setCamera(SelTagWindow.GetText(), int(SelTitleWindow.GetText()));
			root.PopWindow();
			bHandled = True;
			break;

		case exitButton:
			// Do stuff
			root.PopWindow();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	return bHandled;
}

defaultproperties
{
     okButtonText="Ok"
     exitButtonText="Cancel"
     ClientWidth=350
     ClientHeight=85
     clientTextures(0)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_2'
     textureRows=1
     textureCols=2
     bActionButtonBarActive=True
     bUsesHelpWindow=False
     winShadowClass=Class'DeusEx.MenuUIMessageBoxShadowWindow'
}
